<?php
// Include database connection
include("db.php");

// Include PHPMailer classes
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';
require 'PHPMailer/src/Exception.php';

// Set content type to JSON
header('Content-Type: application/json');

// Check if the method is POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Get the raw POST data
    $rawData = file_get_contents('php://input');
    $data = json_decode($rawData, true);

    // Validate inputs
    $email = isset($data['email']) ? $conn->real_escape_string($data['email']) : '';
    $otp = isset($data['otp']) ? $conn->real_escape_string($data['otp']) : '';
    $newPassword = isset($data['password']) ? $data['password'] : '';

    if (empty($email) || empty($otp) || empty($newPassword)) {
        echo json_encode(['status' => 'error', 'message' => 'Email, OTP, and password are required']);
        exit();
    }

    // Check email and OTP
    $sql = "SELECT Id, Name FROM user_login WHERE Email = '$email' AND Otp = '$otp' AND Delete_status = 0 LIMIT 1";
    $result = $conn->query($sql);

    if ($result->num_rows === 1) {
        $user = $result->fetch_assoc();
        $userId = $user['Id'];
        $name = $user['Name'];

        // Hash the new password
        $hashedPassword = password_hash($newPassword, PASSWORD_DEFAULT);

        // Start a transaction
        $conn->begin_transaction();

        try {
            // Update password in user_profile
            $updateProfileSql = "UPDATE user_profile SET Password = '$hashedPassword' WHERE User_id = '$userId'";
            if (!$conn->query($updateProfileSql)) {
                throw new Exception("Failed to update password in user_profile");
            }

            // Update password in user_login
            $updateLoginSql = "UPDATE user_login SET Password = '$hashedPassword', Otp = NULL, Status = 1 WHERE Id = '$userId'";
            if (!$conn->query($updateLoginSql)) {
                throw new Exception("Failed to update password in user_login");
            }

            // Commit the transaction
            $conn->commit();

            // Send success email
            $mail = new PHPMailer();
            $mail->isSMTP();
            $mail->Host = 'smtp.gmail.com'; // Replace with your SMTP server
            $mail->SMTPAuth = true;
            $mail->Username = 'novaronald023@gmail.com'; // Replace with your email
            $mail->Password = 'cfqa wkmj onpp yoai';  // Replace with your email password
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
            $mail->Port = 587;

            
            $mail->setFrom('novaronald023@gmail.com', 'Hapi commerce'); // Replace with your email and name
            $mail->addAddress($email);

            $mail->isHTML(true);
            $mail->Subject = 'Password Reset Successful';
            $mail->Body = "<p>Hello $name,</p><p>Your password has been reset successfully.</p><p>If you did not make this request, please contact support immediately.</p><p>Thank you,</p><p>Hapi commerce</p>";

            if ($mail->send()) {
                echo json_encode(['status' => 'success', 'message' => 'Password reset successfully and confirmation email sent']);
            } else {
                echo json_encode(['status' => 'success', 'message' => 'Password reset successfully but failed to send confirmation email']);
            }
        } catch (Exception $e) {
            // Rollback the transaction
            $conn->rollback();
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Invalid email or OTP']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Only POST method is allowed']);
}

$conn->close();
?>
